<?php
// Set CORS headers to allow requests from any origin
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// This is crucial for handling preflight requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Set the content type to application/json for API responses
header('Content-Type: application/json');

// Include files for database connection and business logic.
// You will need to create a 'NotificationHandler.php' file
// that contains the logic for sending a notification.
require_once __DIR__ . '/../helpers/dbConnect.php';
require_once __DIR__ . '/../pages/NotificationHandler.php';

// Instantiate the necessary classes
$db = new Database();
$notificationHandler = new NotificationHandler($db);

// Get the HTTP request method
$method = $_SERVER['REQUEST_METHOD'];

// Get the JSON data from the request body for POST requests
$input = json_decode(file_get_contents('php://input'), true);

// Use a switch statement to route the request based on the HTTP method
switch ($method) {

    // Handle POST requests to send a notification
    case 'POST':
        // Check if the required 'message' and 'topic' fields are present
        if (empty($input['message']) || empty($input['topic'])) {
            http_response_code(400); // Bad Request
            echo json_encode(['error' => 'Missing message or topic']);
            break;
        }

        // Call the method to send the notification
        // You would implement the logic for this in NotificationHandler.php
        $success = $notificationHandler->sendPushNotification($input['topic'], $input['message']);

        if ($success) {
            http_response_code(200); // OK
            echo json_encode(['success' => true, 'message' => 'Notification sent successfully']);
        } else {
            http_response_code(500); // Internal Server Error
            echo json_encode(['error' => 'Failed to send notification']);
        }
        break;

    // Handle any other unsupported methods
    default:
        http_response_code(405); // 405 Method Not Allowed
        echo json_encode(['error' => 'Method not allowed']);
        break;
}