<?php
// NotificationHandler.php


class NotificationHandler
{

    private $db;
    private $fcmUrl;
    private $accessToken;

    /**
     * Constructor for the NotificationHandler class.
     *
     * @param Database $db The database connection object.
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
        // Replace with your Firebase Project ID and the correct FCM endpoint
        $projectId = 'showbiz-c7c9b';
        $this->fcmUrl = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";

        // Note: For a production app, you would generate and manage this token securely.
        // For testing, you can generate one manually from your service account.
        $this->accessToken = $this->getAccessToken();
    }

    /**
     * Sends a push notification to a specific topic using FCM.
     *
     * @param string $topic The topic to which the notification should be sent (e.g., 'all').
     * @param string $message The body of the notification message.
     * @return bool True on success, false on failure.
     */
    public function sendPushNotification( $topic, $message)
    {
        // The new v1 API requires a specific JSON payload format
        $payload = [
            'message' => [
                'topic' => $topic,
                'notification' => [
                    'title' => 'New Update',
                    'body' => $message,
                ],
            ],
        ];

        $headers = [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $this->accessToken,
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->fcmUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Log the response for debugging
        file_put_contents('fcm_log.log', "HTTP Code: {$httpCode}\nResponse: {$response}\n\n", FILE_APPEND);

        // Check for a successful HTTP status code
        return $httpCode === 200;
    }

    /**
     * This function should be implemented to securely fetch or generate an OAuth 2.0 access token.
     * In a production environment, this token would be managed securely on the server.
     * This is a placeholder for demonstration purposes.
     *
     * @return string The generated access token.
     */
    private function getAccessToken()
    {
        // This is a placeholder. You must securely generate an OAuth 2.0 access token.
        // A common method is to use a Firebase Admin SDK or a service account key file
        // to generate a short-lived token.
        // For local testing, you can use the gcloud CLI: `gcloud auth application-default print-access-token`
        // and paste the result here.
        return 'ya29.A0AS3H6NwRPnsneQmSwK0wsvnVOIRMO1C9GbhkXIqjmGAnzas5DIczpUKpiuKZJGBqrCmeafbxxnG2jrynrF5PiwS7d59ciWdBIinWPB1BLgK0ey7pYgymcdCzLLjb8vj1eQ6j1MiOi_TLWxG1EkAlJ7Fl5XrOJNn0pKftDQ0zRFfAFUv59xtThazy5pLnwHyUPKqwMww89_0aaCgYKAecSARYSFQHGX2MibNvZcDeZkpU0Hpqqhr9vSg0211';
    }
}