<?php

ini_set('display_errors', 1); // SHOW errors
ini_set('display_startup_errors', 1);
ini_set('log_errors', 1);
error_reporting(E_ALL); // REPORT all types of errors
header("Access-Control-Allow-Origin: *");

// 2. Allow specific methods (GET, POST, DELETE, etc.)
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, DELETE");

// 3. Allow specific headers (Content-Type is required for JSON posts)
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// --- SINGLE ENTRY POINT AUTOLOADER ---
// This ensures all Composer packages are loaded for any route.
require __DIR__ . '/vendor/autoload.php';

$request = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
$method = $_SERVER['REQUEST_METHOD'];

if (preg_match('#^api/comments?(/.*)?$#', $request)) {
    require __DIR__ . '/routes/comment_route.php';

} elseif (preg_match('#^api/subscribers?(/.*)?$#', $request)) {
    require __DIR__ . '/routes/subscriber_route.php';

} elseif (preg_match('#^api/comment_interaction?(/.*)?$#', $request)) {
    require __DIR__ . '/routes/comment_interaction_route.php';

} elseif (preg_match('#^api/home?(/.*)?$#', $request)) {
    require __DIR__ . '/routes/home.php';

} elseif (preg_match('#^api/artist?(/.*)?$#', $request)) {
    require __DIR__ . '/routes/artist_rout.php';

} elseif (preg_match('#^api/Notifications?(/.*)?$#', $request)) {
    // This line now correctly includes your notification logic file.
    require __DIR__ . '/routes/send_Notification.php';

} else {
    http_response_code(404);
    echo json_encode(['error' => "404 - Endpoint /$request not found"]);
    exit;
}